# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 9
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR9_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR9(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Initial move: Cooperate
    if current_round == 1:
        return "C"
    
    # Check if opponent is always "C" or "D"
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    
    if always_d:
        return "D"
    if always_c:
        return "D"  # Exploit unconditional cooperators
    
    # Check if opponent defected in the last 2 rounds
    if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
        return "D"
    
    # Endgame: defect from round 8 onward
    if current_round >= 8:
        return "D"
    
    # Default to Tit-for-Tat if no other conditions met
    if len(opp_history) > 0:
        return opp_history[-1]
    
    # Fallback to cooperate
    return "C"